(function(){
  function qs(sel, root){ return (root||document).querySelector(sel); }
  function cleanNumber(raw){
    if(!raw) return '';
    let v = String(raw).trim();
    v = v.replace(/[\s\-().]/g,'');
    v = v.replace(/(?!^)\+/g,'');
    v = v.replace(/[^0-9+]/g,'');
    return v;
  }
  function looksValid(num){
    const digits = num.replace(/\D/g,'');
    if(digits.length < 7) return false;
    if(num === '+') return false;
    return true;
  }

  document.addEventListener('click', function(e){
    const btn = e.target.closest('.kotb-call');
    if(!btn) return;
    const box = btn.closest('[data-kotb]');
    if(!box) return;
    e.preventDefault();

    const input = qs('.kotb-input', box);
    const msg = qs('.kotb-msg', box);
    if(msg) msg.textContent = '';

    const raw = input ? input.value : '';
    if(!raw){
      if(msg) msg.textContent = (window.KOTB && KOTB.msg_empty) ? KOTB.msg_empty : 'Vul eerst een telefoonnummer in.';
      return;
    }
    const num = cleanNumber(raw);
    if(!looksValid(num)){
      if(msg) msg.textContent = (window.KOTB && KOTB.msg_invalid) ? KOTB.msg_invalid : 'Dat telefoonnummer lijkt niet te kloppen.';
      return;
    }

    const href = 'tel:' + encodeURIComponent(num);
    btn.setAttribute('href', href);
    window.location.href = href;
  });

  document.addEventListener('focusin', function(e){
    const input = e.target.closest('.kotb-input');
    if(!input) return;
    const box = input.closest('[data-kotb]');
    const msg = box ? qs('.kotb-msg', box) : null;
    if(msg && !msg.textContent){
      msg.textContent = (window.KOTB && KOTB.msg_hint) ? KOTB.msg_hint : '';
      setTimeout(function(){ if(msg) msg.textContent=''; }, 3500);
    }
  });
})();
