<?php
/*
Plugin Name: Klik om te Bellen (invoer + belknop)
Description: Voeg een simpel invoerveld toe waarmee bezoekers een telefoonnummer kunnen invullen en direct kunnen bellen via hun mobiele toestel.
Version: 1.0
Author: Alexander van Dijl
*/

if (!defined('ABSPATH')) exit;

define('KOTB_VER', '1.0');

add_action('wp_enqueue_scripts', function() {
	wp_enqueue_style('kotb-style', plugins_url('assets/kotb.css', __FILE__), array(), KOTB_VER);
	wp_enqueue_script('kotb-script', plugins_url('assets/kotb.js', __FILE__), array(), KOTB_VER, true);
	wp_localize_script('kotb-script', 'KOTB', array(
		'msg_empty' => 'Vul eerst een telefoonnummer in.',
		'msg_invalid' => 'Dat telefoonnummer lijkt niet te kloppen. Probeer het opnieuw.',
		'msg_hint' => 'Gebruik bij voorkeur landcode, bijvoorbeeld +31…'
	));
});

function kotb_shortcode($atts) {
	$atts = shortcode_atts(array(
		'placeholder' => 'Voer telefoonnummer in (bijv. +31612345678)',
		'button' => 'Bel nu',
		'label' => 'Telefoonnummer',
		'hint' => 'Tip: gebruik landcode (bijv. +31) voor het beste resultaat.',
		'prefill' => '',
	), $atts, 'klik_om_te_bellen');

	$id = 'kotb_' . wp_generate_uuid4();
	$prefill = sanitize_text_field($atts['prefill']);

	return '<div class="kotb" data-kotb>'.
		'<label class="kotb-label" for="'.esc_attr($id).'">'.esc_html($atts['label']).'</label>'.
		'<div class="kotb-row">'.
			'<input class="kotb-input" id="'.esc_attr($id).'" type="tel" inputmode="tel" autocomplete="tel" placeholder="'.esc_attr($atts['placeholder']).'" value="'.esc_attr($prefill).'" />'.
			'<a class="kotb-call" href="#" role="button" aria-label="'.esc_attr($atts['button']).'">'.esc_html($atts['button']).'</a>'.
		'</div>'.
		'<div class="kotb-hint">'.esc_html($atts['hint']).'</div>'.
		'<div class="kotb-msg" aria-live="polite"></div>'.
	'</div>';
}
add_shortcode('klik_om_te_bellen', 'kotb_shortcode');
