(function(){
  function getCfg(){
    if (typeof window.MBC === 'object' && window.MBC) return window.MBC;
    return {};
  }
  function get(obj, path, fallback){
    try{
      var parts = path.split('.');
      var cur = obj;
      for (var i=0;i<parts.length;i++){
        if (!cur || typeof cur !== 'object' || !(parts[i] in cur)) return fallback;
        cur = cur[parts[i]];
      }
      return (cur === undefined || cur === null) ? fallback : cur;
    }catch(e){ return fallback; }
  }
  function parseNLFloat(v){
    if(v===null||v===undefined) return NaN;
    v = String(v).trim();
    if(!v) return NaN;
    v = v.replace(/\./g,'').replace(',', '.');
    return parseFloat(v);
  }
  function formatEUR(n){
    if(!isFinite(n)) return '€ 0,00';
    var parts = n.toFixed(2).split('.');
    var intp = parts[0];
    var dec = parts[1];
    intp = intp.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    return '€ ' + intp + ',' + dec;
  }

  function calc(root){
    var cfg = getCfg();
    var adultPrice = parseNLFloat(root.querySelector('.mbc-adult-price').value);
    var childPrice = parseNLFloat(root.querySelector('.mbc-child-price').value);
    var adults = parseInt(root.querySelector('.mbc-adults').value,10) || 0;
    var children = parseInt(root.querySelector('.mbc-children').value,10) || 0;
    var ticket = parseNLFloat(root.querySelector('.mbc-ticket').value);
    var perMonth = parseInt(root.querySelector('.mbc-per-month').value,10) || 0;

    var persons = adults + children;
    var result = root.querySelector('.mbc-result');

    if(!(adultPrice>=0) || !(childPrice>=0) || !(ticket>0) || persons<=0){
      var invalidMsg = get(cfg, 'i18n.invalid', 'Vul geldige waarden in (ticketprijs > 0 en minimaal 1 persoon).');
      result.innerHTML = '<p><strong>'+invalidMsg+'</strong></p>';
      return;
    }

    var totalCardCost = adultPrice*adults + childPrice*children;
    var normalEntryPerVisit = ticket*persons;

    var breakevenVisits = Math.max(1, Math.ceil(totalCardCost / normalEntryPerVisit));
    var avgCostPerVisitToBE = totalCardCost / breakevenVisits;

    var monthsLine = '';
    if(perMonth>0){
      var months = breakevenVisits / perMonth;
      var monthsRounded = Math.ceil(months*10)/10;
      monthsLine = '<p>Bij <strong>'+perMonth+'</strong> bezoek(en) per maand: breakeven in ongeveer <strong>'+monthsRounded+'</strong> maand(en).</p>';
    } else {
      var hintMsg = get(cfg, 'i18n.months_hint', 'Vul bezoeken per maand in voor een indicatie in maanden.');
      monthsLine = '<p class="mbc-muted">'+hintMsg+'</p>';
    }

    result.innerHTML =
      '<h3>Breakeven: na <strong>'+breakevenVisits+'</strong> bezoek(en).</h3>' +
      '<p>Totale kaartkosten: <strong>'+formatEUR(totalCardCost)+'</strong> voor <strong>'+persons+'</strong> persoon/personen.</p>' +
      '<p>Normale entree per bezoek (zonder kaart): <strong>'+formatEUR(normalEntryPerVisit)+'</strong> (ticketprijs × personen).</p>' +
      '<p>Gemiddelde “kaartkosten” per bezoek tot breakeven: <strong>'+formatEUR(avgCostPerVisitToBE)+'</strong>.</p>' +
      '<p>Na breakeven bespaar je ongeveer <strong>'+formatEUR(normalEntryPerVisit)+'</strong> per extra bezoek (als ticketprijs gelijk blijft).</p>' +
      monthsLine;
  }

  function init(root){
    var cfg = getCfg();
    var a = root.querySelector('.mbc-adult-price');
    var c = root.querySelector('.mbc-child-price');
    var ad = root.querySelector('.mbc-adults');
    var ch = root.querySelector('.mbc-children');
    var t = root.querySelector('.mbc-ticket');

    var ap = parseFloat(get(cfg,'adult_price',79));
    var cp = parseFloat(get(cfg,'child_price',39));
    var dt = parseFloat(get(cfg,'default_ticket_price',17.5));

    a.value = (isFinite(ap)?ap:79).toFixed(2).replace('.',',');
    c.value = (isFinite(cp)?cp:39).toFixed(2).replace('.',',');
    ad.value = parseInt(get(cfg,'default_adults',1),10) || 1;
    ch.value = parseInt(get(cfg,'default_children',0),10) || 0;
    t.value = (isFinite(dt)?dt:17.5).toFixed(2).replace('.',',');

    var btn = root.querySelector('.mbc-btn');
    if(btn){
      btn.addEventListener('click', function(){ calc(root); });
    }

    var tm = null;
    var debounced = function(){
      if (tm) clearTimeout(tm);
      tm = setTimeout(function(){ calc(root); }, 250);
    };
    var inputs = root.querySelectorAll('input');
    for (var i=0;i<inputs.length;i++){
      inputs[i].addEventListener('input', debounced);
      inputs[i].addEventListener('change', debounced);
    }

    calc(root);
  }

  function boot(){
    var nodes = document.querySelectorAll('[data-mbc]');
    for (var i=0;i<nodes.length;i++){ init(nodes[i]); }
  }

  if (document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', boot);
  } else {
    boot();
  }
})();
