
(function($){
  $(function(){

    // Make sure buttons/links are clickable even if a parent has handlers.
    $(document).on('click', '.bv-remove-bank', function(e){
      e.preventDefault();
      e.stopPropagation();
      var $row = $(this).closest('tr');
      if ($row.length === 0) return;
      if (confirm('Weet je zeker dat je deze bank wilt verwijderen?')) {
        $row.fadeOut(150, function(){ $row.remove(); });
      }
    });

    $(document).on('click', '#bv-add-bank', function(e){
      e.preventDefault();
      e.stopPropagation();
      var tplEl = document.getElementById('bv-row-template');
      if (!tplEl) return;
      $('#bv-banks-table tbody').append(tplEl.innerHTML);
      // Scroll to the new row for convenience
      var $last = $('#bv-banks-table tbody tr:last');
      if ($last.length) $last[0].scrollIntoView({behavior:'smooth', block:'center'});
    });

    if (typeof wp !== 'undefined' && wp.media) {
      $(document).on('click', '.bv-pick-logo', function(e){
        e.preventDefault();
        e.stopPropagation();
        var $btn = $(this);
        var $input = $btn.closest('td').find('input.bv-logo-url');
        var frame = wp.media({
          title: 'Kies logo',
          button: { text: 'Gebruik dit logo' },
          multiple: false
        });
        frame.on('select', function(){
          var att = frame.state().get('selection').first().toJSON();
          $input.val(att.url).trigger('change');
        });
        frame.open();
      });
    }

  });
})(jQuery);
