
(function(){
  function init(root){
    var chips = root.querySelectorAll('.bv-chip');
    var bestList = root.querySelector('.bv-best-list');
    var cards = Array.prototype.slice.call(root.querySelectorAll('.bv-card'));

    var banks = cards.map(function(card){
      var id = card.getAttribute('data-bank');
      var titleEl = card.querySelector('.bv-card-title');
      var name = titleEl ? titleEl.textContent.trim() : id;
      var raw = card.getAttribute('data-scores') || '{}';
      var scores = {};
      try { scores = JSON.parse(raw); } catch(e){ scores = {}; }
      return {id:id, name:name, scores:scores};
    });

    function selected(){
      return Array.prototype.slice.call(chips)
        .filter(function(c){ return c.classList.contains('active') && !c.dataset.reset; })
        .map(function(c){ return c.dataset.scenario; });
    }

    function render(){
      if (!bestList) return;
      var sel = selected();
      bestList.innerHTML = '';
      if (sel.length === 0) return;

      var results = banks.map(function(b){
        var total = 0;
        sel.forEach(function(k){ total += (b.scores[k] || 0); });
        return {name:b.name, total: total};
      }).sort(function(a,b){ return b.total - a.total; }).slice(0,3);

      var labels = {speed:'Snel', cash:'Cash', travel:'Reizen', traditional:'Traditioneel', business:'Zakelijk'};
      var reasons = sel.map(function(k){ return labels[k] || k; }).join(' + ');

      results.forEach(function(r, idx){
        var item = document.createElement('div');
        item.className = 'bv-best-item';

        var left = document.createElement('div');
        left.className = 'bv-best-left';

        var nm = document.createElement('div');
        nm.className = 'bv-best-name';
        nm.textContent = (idx+1) + '. ' + r.name;

        var rs = document.createElement('div');
        rs.className = 'bv-best-reason';
        rs.textContent = 'Match op: ' + reasons;

        left.appendChild(nm);
        left.appendChild(rs);

        var sc = document.createElement('div');
        sc.className = 'bv-best-score';
        sc.textContent = r.total + ' pts';

        item.appendChild(left);
        item.appendChild(sc);
        bestList.appendChild(item);
      });
    }

    Array.prototype.slice.call(chips).forEach(function(chip){
      chip.addEventListener('click', function(e){
        e.preventDefault();
        if (chip.dataset.reset){
          Array.prototype.slice.call(chips).forEach(function(c){ c.classList.remove('active'); });
        } else {
          chip.classList.toggle('active');
        }
        render();
      });
    });

    Array.prototype.slice.call(root.querySelectorAll('.bv-segment')).forEach(function(btn){
      btn.addEventListener('click', function(e){
        e.preventDefault();
        Array.prototype.slice.call(root.querySelectorAll('.bv-segment')).forEach(function(b){ b.classList.remove('active'); });
        btn.classList.add('active');
        root.setAttribute('data-active-segment', btn.getAttribute('data-segment'));
      });
    });
  }

  function boot(){
    var roots = document.querySelectorAll('[data-bv]');
    Array.prototype.slice.call(roots).forEach(init);
  }
  if (document.readyState === 'loading'){ document.addEventListener('DOMContentLoaded', boot); } else { boot(); }
})();
